var updater = null;

/**
 * Everything needed for the auto update function and the update panel.
 */
function Updater() {
	this.clientVersion = null;
	this.availableVersion = null;
	this.updateCheck = true;
	this.lastChecked = null;
	this.url = 'http://update.sofa-rockers.org/check/1/';
	
	$('#no').bind('mouseover mousedown', function(event) {
		$(event.target).attr('src', 'Images/cancelUpdate_clicked.png');});
	$('#no').bind('mouseout mouseup', function(event) {
		$(event.target).attr('src', 'Images/cancelUpdate.png');});
	$('#no').click(function(event) {
		$('#update').css('display', 'none');
		if (window.widget)
		    widget.setPreferenceForKey(updater.availableVersion,
		            'noupdate.version');
	});
	$('#yes').bind('mouseover mousedown', function(event) {
		$(event.target).attr('src', 'Images/doUpdate_clicked.png');});
	$('#yes').bind('mouseout mouseup', function(event) {
		$(event.target).attr('src', 'Images/doUpdate.png');});
	$('#yes').click(function(event) {
		if (window.widget)
			widget.openURL('http://stefan.sofa-rockers.org');
			widget.setPreferenceForKey(null, 'noupdate.version');
		$('#update').css('display', 'none');
	});
}

/**
 * Check for updates.
 *
 * Currently checks once a day, I have to change it in a later release ...
 */
Updater.prototype.check = function() {
	if (updater.updateCheck && (!updater.lastChecked
			|| (new Date()).getDate() != updater.lastChecked.getDate())) {
		updater.getVersion();
		$.ajax({
			url: updater.url,
			type: 'GET',
		 	dataType: 'string',
		  	success: function(availableVersion) {
		  	    updater.availableVersion = availableVersion;
				if (availableVersion > updater.clientVersion) {
				    // Check if update is not wanted
				    var buf = widget.preferenceForKey('noupdate.version');
                	if (buf && availableVersion == buf) {
                	    return;
                	}
                	
					$('#clientVersion').text(updater.clientVersion);
					$('#availableVersion').text(availableVersion);
					$('#update').css('display', 'block');
				}
			}
		});
				
		updater.lastChecked = new Date();
	}
};

/**
 * Obtain the current client version from the Info.plist file and set the
 * value to updater.clientVersion.
 */
Updater.prototype.getVersion = function() {
	if (!updater.clientVersion) {
		$.ajax({
			type: "GET",
			url: "Info.plist",
			dataType: "xml",
			async: false,
			success: function(data) {
				updater.clientVersion =
						$('plist > dict > key:contains("CFBundleVersion")', 
						data).next('string').text();
			}
		});
	}
	return updater.clientVersion;
};


